<?php $__env->startSection('title'); ?>
    House Type
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-title'); ?>
    <div class="page-title">
        <div class="row">
            <div class="col-12 col-md-6 order-md-1 order-last">
                <h4><?php echo $__env->yieldContent('title'); ?></h4>
            </div>
            <div class="col-12 col-md-6 order-md-2 order-first">
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <section class="section">
        <div class="card">
            <div class="card-header">
                <div class="divider">
                    <div class="divider-text">
                        <h4>Create House Type</h4>
                    </div>
                </div>
            </div>
            <div class="card-content">
                <div class="card-body">
                    <div class="row">
                        <div class="col-12">
                            <?php echo Form::open(['url' => route('housetype.store')]); ?>

                            <div class="form-group mandatory row ">
                                <?php echo e(Form::label('type', 'House Type', ['class' => 'form-label col-sm-4 text-center'])); ?>

                                <div class="col-sm-4">
                                    <?php echo e(Form::text('type', '', ['class' => 'form-control', 'placeholder' => 'House Type', 'required' => 'true'])); ?>

                                </div>
                                <div class="col-sm-4 d-flex justify-content-start">
                                    <?php echo e(Form::submit('Save', ['class' => 'btn btn-primary me-1 mb-1'])); ?>

                                </div>
                            </div>
                            <?php echo Form::close(); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <section class="section">
        <div class="card">
            <div class="card-body">
                <div class="row">
                    <div class="col-12">
                        <table class="table-light" aria-describedby="mydesc" class='table-striped' id="table_list"
                            data-toggle="table" data-url="<?php echo e(url('housetypeList')); ?>" data-click-to-select="true"
                            data-side-pagination="server" data-pagination="true"
                            data-page-list="[5, 10, 20, 50, 100, 200,All]" data-search="true" data-toolbar="#toolbar"
                            data-show-columns="true" data-show-refresh="true" data-fixed-columns="true"
                            data-fixed-number="1" data-fixed-right-number="1" data-trim-on-search="false"
                            data-mobile-responsive="true" data-sort-name="id" data-sort-order="desc"
                            data-pagination-successively-size="3" data-query-params="queryParams">
                            <thead>
                                <tr>
                                    <th scope="col" data-field="id" data-sortable="true">ID</th>
                                    <th scope="col" data-field="type" data-sortable="true">Type</th>
                                    <?php if(has_permissions('update', 'type')): ?>
                                        <th scope="col" data-field="operate" data-sortable="false">Action</th>
                                    <?php endif; ?>
                                </tr>
                            </thead>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- EDIT MODEL MODEL -->
    <div id="editModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel1" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="myModalLabel1">Edit Type</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form action="<?php echo e(url('house-type-update')); ?>" class="form-horizontal" enctype="multipart/form-data"
                        method="POST" data-parsley-validate>
                        <?php echo e(csrf_field()); ?>


                        <input type="hidden" id="edit_id" name="edit_id">
                        <div class="row">
                            <div class="col-md-12 col-12">
                                <div class="form-group mandatory">
                                    <label for="edit_type" class="form-label col-12">Type</label>
                                    <input type="text" id="edit_type" class="form-control col-12" placeholder="Bedroom"
                                        name="edit_type" data-parsley-required="true">
                                </div>
                            </div>
                        </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary waves-effect" data-bs-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary waves-effect waves-light">Save</button>
                    </form>
                </div>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
    <!-- EDIT MODEL -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        function queryParams(p) {
            return {
                sort: p.sort,
                order: p.order,
                offset: p.offset,
                limit: p.limit,
                search: p.search
            };
        }

        function setValue(id) {
            //$('#editUserForm').attr('action', ($('#editUserForm').attr('action') +'/edit/'+id));
            $("#edit_id").val(id);
            $("#edit_type").val($("#" + id).parents('tr:first').find('td:nth-child(2)').text());

        }
    </script>
    
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/wrteam-dev/Documents/eBroker_Scripts/eBroker_Admin_Panel_1.1.0/code/resources/views/house_type/index.blade.php ENDPATH**/ ?>